"""
应用配置模块
使用 Pydantic Settings 管理配置参数
"""

from pydantic_settings import BaseSettings
from typing import List
import os


class Settings(BaseSettings):
    """应用配置类"""

    # 应用基本信息
    APP_NAME: str = "绩效计分系统API"
    APP_VERSION: str = "1.0.0"
    DEBUG: bool = True

    # 服务器配置
    HOST: str = "0.0.0.0"
    PORT: int = 8000
    API_HOST: str = "0.0.0.0"  # 兼容性字段
    API_PORT: int = 8000       # 兼容性字段

    # 数据库配置
    DATABASE_URL: str = "postgresql://performance_user:performance_pass@localhost:5432/performance_db"

    # JWT 配置
    JWT_SECRET_KEY: str = "local-development-secret-key-not-for-production"
    JWT_ALGORITHM: str = "HS256"
    JWT_EXPIRE_HOURS: int = 24
    SECRET_KEY: str = "your-secret-key-here-change-in-production"  # 兼容性字段

    # 文件上传配置
    UPLOAD_DIR: str = "uploads"
    MAX_FILE_SIZE: int = 5242880  # 5MB
    MAX_IMAGES_PER_INSTITUTION: int = 10

    # CORS 配置
    CORS_ORIGINS: str = "http://localhost:5173,http://localhost:4001,http://localhost:8080"  # 允许的前端域名

    # WebSocket 配置
    WEBSOCKET_HEARTBEAT_INTERVAL: int = 30
    WEBSOCKET_TIMEOUT: int = 60

    # 系统配置
    ENABLE_REAL_TIME_SYNC: bool = True
    SYNC_EVENT_RETENTION_DAYS: int = 30
    SESSION_CLEANUP_INTERVAL: int = 3600

    # 日志配置
    LOG_LEVEL: str = "INFO"
    LOG_FILE: str = "logs/api.log"

    # 数据迁移配置
    MIGRATION_BATCH_SIZE: int = 100

    class Config:
        # 从项目根目录读取 .env 文件
        env_file = os.path.join(os.path.dirname(os.path.dirname(__file__)), ".env")
        case_sensitive = True
        extra = "ignore"  # 忽略额外的环境变量


# 创建全局配置实例
settings = Settings()
