"""
数据库迁移系统
提供安全的数据库schema更新机制

特性:
- 事务保护：所有迁移在事务中执行
- 验证机制：迁移前后都有验证步骤  
- 回滚支持：每个迁移都有对应的回滚方法
- 备份点：迁移前自动创建备份点记录
- 原子性：迁移要么全部成功，要么全部失败
- 版本跟踪：精确记录每个迁移的执行状态
"""

__version__ = "1.0.0"
__author__ = "Performance System Team"

from .base import Migration, MigrationError
from .manager import MigrationManager, migration_manager

__all__ = [
    "Migration",
    "MigrationError", 
    "MigrationManager",
    "migration_manager"
]
