"""
Migration 1.0.4: 为月度历史记录表添加institutions_data字段
"""

from migrations.base import Migration
from loguru import logger


class AddInstitutionsDataMigration(Migration):
    """为月度历史记录表添加institutions_data字段的迁移"""
    
    def __init__(self):
        super().__init__(
            version="1.0.4",
            description="为月度历史记录表添加institutions_data字段"
        )
    
    async def up(self, db):
        """执行迁移：添加institutions_data字段"""
        try:
            # 添加institutions_data字段
            await db.execute("""
                ALTER TABLE monthly_history
                ADD COLUMN institutions_data JSONB
            """)

            logger.info("✅ 成功添加institutions_data字段到monthly_history表")
            return True

        except Exception as e:
            logger.error(f"❌ 添加institutions_data字段失败: {e}")
            raise
    
    async def down(self, db):
        """回滚迁移：删除institutions_data字段"""
        try:
            # 删除institutions_data字段
            await db.execute("""
                ALTER TABLE monthly_history
                DROP COLUMN IF EXISTS institutions_data
            """)

            logger.info("✅ 成功删除institutions_data字段")
            return True

        except Exception as e:
            logger.error(f"❌ 删除institutions_data字段失败: {e}")
            raise
    
    async def validate(self, db):
        """验证迁移结果"""
        try:
            # 检查institutions_data字段是否存在
            result = await db.fetch_one("""
                SELECT column_name 
                FROM information_schema.columns 
                WHERE table_name = 'monthly_history' 
                AND column_name = 'institutions_data'
            """)
            
            if result:
                logger.info("✅ institutions_data字段验证成功")
                return True
            else:
                logger.error("❌ institutions_data字段不存在")
                return False

        except Exception as e:
            logger.error(f"❌ 验证institutions_data字段失败: {e}")
            return False


# 创建迁移实例
migration = AddInstitutionsDataMigration()
