@echo off
chcp 65001 >nul
echo 🚀 启动绩效计分系统后端开发服务器...

REM 检查虚拟环境是否存在
if not exist "venv\Scripts\activate.bat" (
    echo ❌ 虚拟环境不存在，请先创建虚拟环境：
    echo    python -m venv venv
    echo    venv\Scripts\activate.bat
    echo    pip install -r requirements.txt
    pause
    exit /b 1
)

REM 激活虚拟环境
echo 📦 激活虚拟环境...
call venv\Scripts\activate.bat

REM 设置环境变量
echo ⚙️ 设置环境变量...
set DATABASE_URL=postgresql://performance_user:performance_pass@localhost:5431/performance_db
set DEBUG=True

REM 启动开发服务器
echo 🌟 启动 FastAPI 开发服务器...
echo 📍 服务地址: http://localhost:8000
echo 📖 API 文档: http://localhost:8000/docs
echo 🔄 热重载已启用，修改代码后会自动重启
echo ⏹️ 按 Ctrl+C 停止服务器
echo.

uvicorn main:app --reload --host 0.0.0.0 --port 8000
