# 绩效计分系统后端开发服务器启动脚本
# 使用方法：在 backend 目录下运行 .\start_dev.ps1

Write-Host "🚀 启动绩效计分系统后端开发服务器..." -ForegroundColor Green

# 检查虚拟环境是否存在
if (-not (Test-Path ".\venv\Scripts\Activate.ps1")) {
    Write-Host "❌ 虚拟环境不存在，请先创建虚拟环境：" -ForegroundColor Red
    Write-Host "   python -m venv venv" -ForegroundColor Yellow
    Write-Host "   .\venv\Scripts\Activate.ps1" -ForegroundColor Yellow
    Write-Host "   pip install -r requirements.txt" -ForegroundColor Yellow
    exit 1
}

# 激活虚拟环境
Write-Host "📦 激活虚拟环境..." -ForegroundColor Blue
& .\venv\Scripts\Activate.ps1

# 设置环境变量
Write-Host "⚙️ 设置环境变量..." -ForegroundColor Blue
$env:DATABASE_URL = "postgresql://performance_user:performance_pass@localhost:5431/performance_db"
$env:DEBUG = "True"

# 检查数据库连接
Write-Host "🔍 检查数据库连接..." -ForegroundColor Blue
try {
    $response = Invoke-RestMethod -Uri "http://localhost:5431" -Method Get -TimeoutSec 2 -ErrorAction Stop
} catch {
    Write-Host "⚠️ 数据库可能未启动，请确保 Docker 容器正在运行：" -ForegroundColor Yellow
    Write-Host "   docker compose up -d postgres" -ForegroundColor Yellow
}

# 启动开发服务器
Write-Host "🌟 启动 FastAPI 开发服务器..." -ForegroundColor Green
Write-Host "📍 服务地址: http://localhost:8000" -ForegroundColor Cyan
Write-Host "📖 API 文档: http://localhost:8000/docs" -ForegroundColor Cyan
Write-Host "🔄 热重载已启用，修改代码后会自动重启" -ForegroundColor Cyan
Write-Host "⏹️ 按 Ctrl+C 停止服务器" -ForegroundColor Yellow
Write-Host ""

uvicorn main:app --reload --host 0.0.0.0 --port 8000
