import { createApp } from 'vue'
import { createPinia } from 'pinia'
import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'
import 'element-plus/theme-chalk/dark/css-vars.css'
import * as ElementPlusIconsVue from '@element-plus/icons-vue'

import App from './App.vue'
import router from './router'
import './styles/global.css'
import { useDataStore } from './store/data'
import { useAuthStore } from './store/auth'

const app = createApp(App)

// 注册Element Plus图标
for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
  app.component(key, component)
}

const pinia = createPinia()

app.use(pinia)
app.use(router)
app.use(ElementPlus)

// 初始化应用
const initializeApp = async () => {
  try {
    console.log('🚀 正在初始化绩效计分系统...')

    // 挂载应用（认证状态恢复在路由守卫中处理）
    app.mount('#app')

    console.log('🎉 绩效计分系统初始化完成')

  } catch (error) {
    console.error('❌ 应用初始化失败:', error)

    // 即使初始化失败，也要挂载应用（降级模式）
    app.mount('#app')
  }
}

// 启动应用
initializeApp()